
Type Demo3Screen Extends TScreen

	Field agentTexture:TImage
	Field agentCrossBeamTexture:TImage
	Field agentBody:TBody
	Field agentGeom:TGeom[7] 
	
	Field floorTexture:TImage
	Field floorBody:TBody
	Field floorGeom:TGeom
	
	Field obstacleBody:TBody[] 
	Field obstacleGeom:TGeom[] 
	Field obstacleTexture:TImage
	
	Method Draw(delta:Float)
		DrawFloor() 
		DrawObstacles() 
		DrawAgent()
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw() 
		End If
	End Method
	
	Method DrawAgent() 
		For Local i:Int = 5 To agentGeom.Length - 1
			Local geom:TGeom = agentGeom[i] 
			SetOrigin(geom.GetPosition().X, geom.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(geom.GetRotation())) 
			DrawImage(agentCrossBeamTexture, 0, 0) 
		Next
		
		For Local i:Int = 0 To 4
			Local geom:TGeom = agentGeom[i] 
				SetOrigin(geom.GetPosition().X, geom.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(geom.GetRotation())) 
			DrawImage(agentTexture, 0, 0) 
		Next
		SetOrigin(0, 0) 
		SetRotation(0) 
	End Method
	
	Method DrawFloor() 
		DrawImage(floorTexture, floorBody.GetPosition().X, floorBody.GetPosition().Y) 		
	End Method
	
	Method DrawObstacles() 
		For Local o:TBody = EachIn obstacleBody
			SetOrigin(o.GetPosition().X, o.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(o.GetRotation())) 
			DrawImage(obstacleTexture, 0, 0) 
		Next
		SetOrigin(0, 0) 
		SetRotation(0) 
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf 
		Self.HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta) 
	End Method
	
	Method Load() 
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 100)) 
		view = TPhysicsSimulatorView.Create(physics) 
		LoadAgent() 
		LoadFloor() 
		LoadObstacles() 
	End Method
	
	Method LoadAgent() 
		agentTexture = TDrawingHelper.CreateCircleTexture(16, TColor.Yellow, TColor.Black, 2) 
		agentCrossBeamTexture = TDrawingHelper.CreateRectangleTexture(16, 120, TColor.DarkGray, TColor.Black, 2) 
		 MidHandleImage(agentTexture) 
		 MidHandleImage(agentCrossBeamTexture) 
		 
		agentBody = TBodyFactory.CreateRectangleBody(physics, 80, 80, 5)
		agentbody.SetPosition(Vector2.Create(TDemo.gfxWidth / 2, 110)) 
		
		agentGeom = New TGeom[7] 
		agentGeom[0] = TGeomFactory.CreateCircleGeom(physics, agentBody, 16, 10, Vector2.Create(- 40, - 40), 0)
		agentGeom[0].SetRestitutionCoefficient(.2) 
		agentGeom[0].SetFrictionCoefficient(.2) 
		agentGeom[0].SetCollisionGroup(1) 
		agentGeom[1] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(- 40, 40), 0)
		agentGeom[2] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(40, - 40), 0)
		agentGeom[3] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(40, 40), 0)
		agentGeom[4] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(0, 0), 0)
		
		agentGeom[5] = TGeomFactory.CreateRectangleGeom(physics, agentBody, 16, 130, Vector2.Zero(), MathHelper.PiOver4)
		agentGeom[5].SetCollisionGroup(1) 
		agentGeom[6] = TGeomFactory.CreateRectangleGeom(physics, agentBody, 16, 130, Vector2.Zero(), - MathHelper.PiOver4)
		agentGeom[6].SetCollisionGroup(1) 
		
	End Method
	
	Method LoadFloor() 
		floorTexture = TDrawingHelper.CreateRectangleTexture(TDemo.gfxWidth, 100, TColor.White, TColor.Black, 2) 
		MidHandleImage(floorTexture) 
		
		floorBody = TBodyFactory.CreateRectangleBody(physics, TDemo.gfxWidth, 100, 1)
		floorBody.SetStatic(True) 
		floorGeom = TGeomFactory.CreateRectangleGeom(physics, floorBody, TDemo.gfxWidth, 100)
		floorGeom.SetRestitutionCoefficient(.2) 
		floorGeom.SetFrictionCoefficient(.2) 
		floorBody.SetPosition(Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight - 50)) 
		
	End Method
	
	Method LoadObstacles() 
		obstacleTexture = TDrawingHelper.CreateRectangleTexture(128, 32, TColor.White, TColor.Black, 2) 
		MidHandleImage(obstacleTexture) 
		
		obstacleBody = New TBody[5] 
		obstacleGeom = New TGeom[5] 
		
		For Local i:Int = 0 To obstacleBody.Length - 1
			obstacleBody[i] = TBodyFactory.CreateRectangleBody(physics, 128, 32, 1) 
			obstacleBody[i].SetStatic(True) 
			
			If i = 0 Then
				obstacleGeom[i] = TGeomFactory.CreateRectangleGeom(physics, obstacleBody[i], 128, 32)
				obstacleGeom[i].SetRestitutionCoefficient(.2) 
				obstacleGeom[i].SetFrictionCoefficient(.2) 
			Else
				obstacleGeom[i] = TGeomFactory.CloneGeom(physics, obstacleBody[i], obstacleGeom[0])
			End If
		Next
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight / 2) 
		obstacleBody[0].SetPosition(Vector2.AddVectors(center, Vector2.Create(- 50, - 200))) 
		obstacleBody[1].SetPosition(Vector2.AddVectors(center, Vector2.Create(150, - 100))) 
		obstacleBody[2].SetPosition(Vector2.AddVectors(center, Vector2.Create(100, 50))) 
		obstacleBody[3].SetPosition(Vector2.AddVectors(center, Vector2.Create(- 100, 200))) 
		obstacleBody[4].SetPosition(Vector2.AddVectors(center, Vector2.Create(- 170, 0))) 
		
	End Method
	
	Method Unload() 
		
	End Method
	
	Method OnEscapeKeyHit() 
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method	
	
	Method Gettitle:String() 
		Return "Static Bodies and offset geometries"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows a single body with multiple geometry")
		sb.AppendLine("objects attached.  The yellow circles are offset")
		sb.AppendLine("from the bodies center. The body itself is created")
		sb.AppendLine("using 'CreateRectangleBody' so that it's moment of")
		sb.AppendLine("inertia is that of a rectangle.")
		sb.AppendLine("")
		sb.AppendLine("This demo also shows the use of static bodies.")
		sb.AppendLine("")	
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag")
		Return sb
	End Method
	
	Method HandleKeyboardInput() 
		Local forceAmount:Float = 800
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 10000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If		
	End Method
	
End Type
